#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

typedef __int128_t int128;

int main() {
    
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int n;
    if (!(cin >> n)) return 0;
   
    vector<long long> X(n);
    vector<long long> Y(n);
    vector<pair<double, int>> podaci(n);

    for (int i = 0; i < n; i++) {
        cin >> X[i] >> Y[i];
        double ugao = atan2((double)Y[i], (double)X[i]);
        podaci[i] = make_pair(ugao, i);
    }

    sort(podaci.begin(), podaci.end());

    vector<long long> X1, Y1;
    vector<double> u; 
    vector<int> ind;
    double PI = acos(-1.0);

    for (int k = 0; k < 2; k++) {
        for (int i = 0; i < n; i++) {
            double tu = podaci[i].first;
            if (k == 1) tu += 2 * PI;
            u.push_back(tu);

            int idx = podaci[i].second;
            X1.push_back(X[idx]);
            Y1.push_back(Y[idx]);
            ind.push_back(idx);
        }
    }

    int r = 0;
    int128 curX = 0, curY = 0; 
    int128 maxD = -1;
    int bestL = 0, bestR = -1;

    for (int l = 0; l < n; l++) {
        while (r < 2 * n && (u[r] - u[l] <= PI + 1e-9)) {
            curX += X1[r];
            curY += Y1[r];
            
            int128 sad = curX * curX + curY * curY;
            if (sad > maxD) {
                maxD = sad;
                bestL = l;
                bestR = r;
            }
            r++;
        }
        if (l < r) {
            curX -= X1[l];
            curY -= Y1[l];
        } else {
            r = l + 1;
        }
    }

    cout << bestR - bestL + 1 << endl;
    for (int i = bestL; i <= bestR; i++) {
        cout << ind[i] + 1 << " ";
    }
    cout << endl;

    return 0;
}